<?php

$naviItems = $partnerNavi;

if (!is_array($naviItems)) {
  $naviItems = [
    // Förderung finden
    'immobilien', 'aktuelles',
    // Förderung bekommen
    'neubau', 'hauskauf', 'modernisierung', 'heizung',
    // Finanzierung
    'foerdermoeglichkeiten', 'kontakt',
    // Energiesparen
    'energieberatung', 'energiesparrechner'
  ];
}

function isNavItemActive($key, $items) {
  return in_array($key, $items);
}
?>
<!-- Barrierefreier Bootstrap Header mit Logo über Navbar -->
<style>
  /* Für sichtbare Tastatur-Fokus-Indikatoren */
  a:focus-visible, button:focus-visible {
    outline: 3px solid #005fcc;
    outline-offset: 2px;
  }
</style>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const dropdowns = document.querySelectorAll('.navbar .dropdown');

    dropdowns.forEach(function (dropdown) {
      const toggle = dropdown.querySelector('.dropdown-toggle');
      const menu = dropdown.querySelector('.dropdown-menu');

      // Hover für große Bildschirme
      if (window.innerWidth >= 992) {
        dropdown.addEventListener('mouseenter', function () {
          toggle.classList.add('show');
          toggle.setAttribute('aria-expanded', 'true');
          menu.classList.add('show');
        });

        dropdown.addEventListener('mouseleave', function () {
          toggle.classList.remove('show');
          toggle.setAttribute('aria-expanded', 'false');
          menu.classList.remove('show');
        });
      }

      // Tastatur: Dropdown per Enter oder Space öffnen/schließen
      toggle.addEventListener('keydown', function (e) {
        if (e.key === 'Enter' || e.key === ' ') {
          e.preventDefault();
          const isOpen = menu.classList.contains('show');
          toggle.setAttribute('aria-expanded', String(!isOpen));
          menu.classList.toggle('show');
        }
      });
    });
  });
</script>
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const path = window.location.pathname;

    // Alle Nav-Links durchgehen
    document.querySelectorAll(".navbar-nav .nav-link, .navbar-nav .dropdown-item").forEach(link => {
      const href = link.getAttribute("href");
      if (path.includes(href)) {
        link.classList.add("active");

        // Auch das übergeordnete <li> mit Dropdown-Link markieren
        const parentDropdown = link.closest(".dropdown-menu")?.previousElementSibling;
        if (parentDropdown) {
          parentDropdown.classList.add("active");
        }
      }
    });
  });
</script>
<header class="bg-white no-fixed-header" role="banner">
  <div class="logo-wrapper container py-2 d-flex justify-content-between align-items-center" style="height: 150px;">
	<!-- Linkes Logo -->
		<?php if($partner) : ?>
			<a href="." class="d-inline-block" aria-label="Zur Startseite">												
				<img class="logo" style="border-width:0px;" alt="Logo" title="logo" src="getLogo.php?uid=<?php echo urlencode($uid);?>">							
			</a>
	  <?php else: ?>
			<a href="." class="d-inline-block" aria-label="Zur Startseite">												
				<img class="logo" style="border-width:0px;" alt="Logo" title="logo" src="pix/logo-starpool.png">							
			</a>			  
	  <?php endif;?>
				
    <!-- Rechtes Logo -->
    <a href="https://partnerseite.de" class="d-inline-block d-none" aria-label="Zur Partnerseite">
      <img src="pfad/zum/logo-rechts.png" alt="Logo rechts" style="max-height: 60px;">
    </a>
  </div>

  <nav class="navbar navbar-expand-lg navbar-starpool pt-0 pb-0" role="navigation" aria-label="Hauptnavigation">
    <div class="container">
      <a class="navbar-brand" href="Ueber-Uns"><?php echo $partner ?></a>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar"
        aria-controls="mainNavbar" aria-expanded="false" aria-label="Navigation ein-/ausklappen">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="mainNavbar">
        <ul class="navbar-nav ms-auto mb-2 mb-lg-0">

  <!-- FÖRDERUNG FINDEN -->
  <?php if (
    isNavItemActive('immobilien', $naviItems) ||
    isNavItemActive('aktuelles', $naviItems)
  ): ?>
    <li class="nav-item dropdown">
      <a class="nav-link dropdown-toggle" href="#" id="dropdown1" role="button" data-bs-toggle="dropdown" aria-expanded="false" aria-haspopup="true">
        FÖRDERUNG FINDEN
      </a>
      <ul class="dropdown-menu" role="menu" aria-labelledby="dropdown1">
        <?php if (isNavItemActive('immobilien', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Immobilien">Immobilien</a></li>
        <?php endif; ?>
        <?php if (isNavItemActive('aktuelles', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Aktuelles">Aktuelles</a></li>
        <?php endif; ?>
      </ul>
    </li>
  <?php endif; ?>

  <!-- FÖRDERUNG BEKOMMEN -->
  <?php if (
    isNavItemActive('neubau', $naviItems) ||
    isNavItemActive('hauskauf', $naviItems) ||
    isNavItemActive('modernisierung', $naviItems) ||
    isNavItemActive('heizung', $naviItems)
  ): ?>
    <li class="nav-item dropdown">
      <a class="nav-link dropdown-toggle" href="#" id="dropdown2" role="button" data-bs-toggle="dropdown" aria-expanded="false" aria-haspopup="true">
        FÖRDERUNG BEKOMMEN
      </a>
      <ul class="dropdown-menu" role="menu" aria-labelledby="dropdown2">
        <?php if (isNavItemActive('neubau', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Neubau">Neubau</a></li>
        <?php endif; ?>
        <?php if (isNavItemActive('hauskauf', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Hauskauf">Hauskauf</a></li>
        <?php endif; ?>
        <?php if (isNavItemActive('modernisierung', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Modernisierung">Modernisierung</a></li>
        <?php endif; ?>
        <?php if (isNavItemActive('heizung', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Heizung">Heizung</a></li>
        <?php endif; ?>
      </ul>
    </li>
  <?php endif; ?>

  <!-- FINANZIERUNG -->
  <?php if (
    isNavItemActive('foerdermoeglichkeiten', $naviItems) ||
    isNavItemActive('kontakt', $naviItems)
  ): ?>
    <li class="nav-item dropdown">
      <a class="nav-link dropdown-toggle" href="#" id="dropdown3" role="button" data-bs-toggle="dropdown" aria-expanded="false" aria-haspopup="true">
        FINANZIERUNG
      </a>
      <ul class="dropdown-menu" role="menu" aria-labelledby="dropdown3">
        <?php if (isNavItemActive('foerdermoeglichkeiten', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Foerdermoeglichkeiten">Fördermöglichkeiten</a></li>
        <?php endif; ?>
        <?php if (isNavItemActive('kontakt', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Kontakt">Kontakt</a></li>
        <?php endif; ?>
      </ul>
    </li>
  <?php endif; ?>

  <!-- ENERGIESPAREN -->
  <?php if (
    isNavItemActive('energieberatung', $naviItems) ||
    isNavItemActive('energiesparrechner', $naviItems) ||
    isNavItemActive('energiesparfilme', $naviItems)
  ): ?>
    <li class="nav-item dropdown">
      <a class="nav-link dropdown-toggle" href="#" id="dropdown4" role="button" data-bs-toggle="dropdown" aria-expanded="false" aria-haspopup="true">
        ENERGIESPAREN
      </a>
      <ul class="dropdown-menu" role="menu" aria-labelledby="dropdown4">
        <?php if (isNavItemActive('energieberatung', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Energieberater">Energieberatung</a></li>
        <?php endif; ?>
        <?php if (isNavItemActive('energiesparrechner', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Energiesparrechner">Energiesparrechner</a></li>
        <?php endif; ?>
        <?php if (isNavItemActive('energiesparfilme', $naviItems)): ?>
          <li><a class="dropdown-item" role="menuitem" href="Energiesparfilme">Energiesparfilme</a></li>
        <?php endif; ?>
      </ul>
    </li>
  <?php endif; ?>

</ul>

      </div>
    </div>
  </nav>
</header>
