<?php
define("dbFile", __DIR__ . "/admin/data/database.sqlite");

try {
    $db = new PDO('sqlite:' . dbFile);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    http_response_code(500);
    exit("Datenbankfehler");
}

// ID validieren
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($id <= 0) {
    header("HTTP/1.1 400 Bad Request");
    exit("Ungültige ID");
}

// Bild abrufen
$stmt = $db->prepare("SELECT image FROM news WHERE id = :id AND active = 1");
$stmt->execute([':id' => $id]);
$imageData = $stmt->fetchColumn();

if ($imageData) {
    // MIME-Type automatisch erkennen
    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mimeType = $finfo->buffer($imageData);

    // Nur erlaubte Bildtypen
    if (in_array($mimeType, ['image/jpeg', 'image/png', 'image/gif'])) {
        ob_clean(); // falls schon Ausgabe im Puffer
        header("Content-Type: $mimeType");
        header("Content-Length: " . strlen($imageData));
        echo $imageData;
        exit;
    }
}

// Fallback-Bild anzeigen
header("Content-Type: image/png");
readfile(__DIR__ . "/pix/kein-bild.png");
exit;