<!-- Einleitung -->
<section aria-labelledby="neubau-einleitung" class="py-5" role="region">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center text-uppercase">
        <h1 id="neubau-einleitung">Fördermöglichkeiten im Neubau</h1>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <p>Damit sich der Schritt ins Eigenheim auch langfristig als lohnende Investition auszahlt, ist eine gesicherte Finanzierung das beste Fundament. Dabei sollte man auch die bereitstehenden Förderprogramme nutzen.</p>
        <p>Der Staat fördert derzeit vor allem besonders klimafreundliche Energiesparhäuser. Ebenfalls steht die Bildung von Wohneigentum zur Absicherung im Alter im Förderfokus von Bund und Ländern. Auch regionale Programme sind attraktiv &ndash; z.?B. mit Nachlässen auf Grundstücke oder Förderung in Neubaugebieten.</p>
      </div>
    </div>
  </div>
</section>

<!-- Förderprogrammübersicht -->
<section aria-labelledby="klimafreundlich-ueberschrift" class="bg-grey py-5" role="region">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h2 id="klimafreundlich-ueberschrift">Förderung für klimafreundlichen Neubau</h2>
        <p class="text-start">
          Noch nie war es so wichtig, energiesparend zu bauen. Im Neubau kann man die Weichen von Anfang an richtig stellen: möglichst <strong>wenig Energie</strong> verbrauchen und die benötigte Wärme sowie den Strom durch <strong>erneuerbare Energien</strong> decken.<br><br>
          Gefördert werden Gebäude, die hohe energetische Standards (Effizienzhaus 40) erfüllen und nachhaltig gebaut sind. CO2-Emissionen, Materialherkunft und Umweltwirkungen vom Rohstoff bis zur Nutzung werden bewertet. Nachhaltige Baustoffe und Konzepte sind zentrale Bestandteile der QNG-Zertifizierung.
        </p>
      </div>
    </div>

    <div class="row mt-4" role="list" aria-label="Geförderte Neubauvarianten">

      <!-- Mindeststandard -->
      <article class="col-md-4 mb-4" role="listitem">
        <div class="text-center mb-3">
          <img src="pix/icons/neubau-gesetzlicher-mindeststandard-im-neubau.svg" class="img-fluid  d-block mx-auto" alt="Illustration zum Effizienzhaus 55" style="max-width: 50%;" />
        </div>
        <ul>
          <li>festgelegt im Gebäudeenergiegesetz (GEG)</li>
          <li><strong>Effizienzhaus 55</strong> ist energetischer Mindeststandard</li>
          <li>Der im Rahmen der Effizienzhausplanung berechnete Primärenergiebedarf darf maximal 55% des Bedarfs eines Referenzgebäudes betragen</li>
        </ul>
      </article>

      <!-- Klimafreundliches Wohngebäude -->
      <article class="col-md-4 mb-4" role="listitem">
        <div class="text-center mb-3">
          <img src="pix/icons/neubau-klimafreundliches-wohngebaeude.svg" class="img-fluid d-block mx-auto"  style="max-width: 50%;" alt="Symbolbild klimafreundliches Wohngebäude" />
        </div>
        <p>Ein Gebäude gilt als klimafreundlich, wenn es:</p>
        <ul>
          <li>wenig Energie verbraucht und als <strong>Effizienzhaus 40</strong> eingestuft wird</li>
          <li><strong>wenig Emissionen</strong> verursacht und damit die Anforderungen an Treibhausgasemissionen des Qualitätssiegels Nachhaltiges Gebäude (QNG) erfüllt</li>
          <li>nicht mit Öl, Gas oder Biomasse beheizt wird</li>
        </ul>
        <p>Die Anforderungen muss ein Energieeffizienz-Experte einplanen und überprüfen</p>
      </article>

      <!-- QNG-zertifiziertes Wohngebäude -->
      <article class="col-md-4 mb-4" role="listitem">
        <div class="text-center mb-3">
          <img src="pix/icons/neubau-klimafreundliches-wohngebaeude-mit-qng.svg" class="img-fluid d-block mx-auto"  style="max-width: 50%;" alt="Qualitätssiegel Nachhaltiges Gebäude" />
        </div>
        <p>Ein Gebäude erreicht diese Förderstufe wenn es:</p>
        <ul>
          <li>als <strong>Effizienzhaus 40</strong> eingestuft wird</li>
          <li>die Anforderungen des Qualitätssiegels Nachhaltiges Gebäude <strong>(QNG-Plus)</strong> oder <strong>(QNG-Premium)</strong> erfüllt - bestätigt durch ein <strong>Nachhaltigkeitszertifikat</strong></li>
          <li>nicht mit Öl-, Gas oder Biomasse beheizt wird</li>
        </ul>
        <p>Die Anforderungen muss ein Energieeffizienz-Experte und ein Berater für Nachhaltigkeit einplanen und überprüfen</p>
      </article>

    </div>

    <div class="row mt-5">
      <div class="col-md-12 text-center">
        <a href="Immobilien" class="btn btn-warning" aria-label="Zur Fördergeld-Suche für Immobilien">
          <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Zur Fördergeld-Suche</strong>
        </a>
      </div>
    </div>
  </div>
</section>

<!-- Beispielförderung -->
<section aria-labelledby="beispielfoerderung-ueberschrift" class="py-5" role="region">
  <div class="container">
    <h2 id="beispielfoerderung-ueberschrift" class="text-center">Beispielförderung Neubau Einfamilienhaus</h2>
    <h3 class="text-center">In unserem Beispiel plant eine Familie den Neubau ihres energiesparenden Einfamilienhauses nach Effizienzhaus-Standard 40 NH.</h3>

    <div class="row mt-4" role="list" aria-label="Beispielfinanzierungspakete">

      <!-- Paket 1 -->
      <article class="col-md-4" role="listitem" aria-labelledby="paket1" >
        <h4 id="paket1"><strong>BFH-Finanz GmbH</strong></h4>
        <p>zugeschnittenes Finanzierungspaket</p>
        <ul>
          <li>400.000 &euro; Baukosten</li>
          <li>80.000 &euro; Eigenkapital</li>
        </ul>
      </article>

      <!-- Paket 2 -->
      <article class="col-md-4 article-divider" role="listitem" aria-labelledby="paket2">
        <h4 id="paket2"><strong>Finanzierung mit KFN-Förderdarlehen</strong></h4>
        <ul>
          <li>100.000 &euro; Kredit je Wohneinheit für ein Effizienzhaus 40</li>
          <li>220.000 &euro; bankfinanziert</li>
        </ul>
      </article>

      <!-- Paket 3 -->
      <article class="col-md-4" role="listitem" aria-labelledby="paket3">
        <h4 id="paket3"><strong>KFN mit Wohneigentumsprogramm kombinieren</strong></h4>
        <ul>
          <li>Bis zu 100.000 &euro; des neuen Eigenheims können über das KfW-Wohneigentumsprogramm finanziert werden</li>
          <li>Erfüllt der Neubau zusätzlich die Kriterien eines Klimafreundlichen Gebäudes, können beide Förderprogramme genutzt werden</li>
          <li>100.000 &euro; Klimafreundliches Gebäude / Effizienzhaus 40</li>
		  <li>100.000 &euro; KfW-Wohneigentumsprogramm</li>
		  <li>120.000 &euro; Bankfinanziert</li>
        </ul>
        <p>Beide Programme können kombiniert werden, wenn alle Kriterien erfüllt sind.</p>
      </article>

    </div>
  </div>
</section>
