<!-- Einleitung -->
<section class="py-5" aria-labelledby="luftdichtheit-ueberschrift">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h1 id="luftdichtheit-ueberschrift" class="text-uppercase">Luftdichtheitsmessung</h1>
        <h3>Gebäudehülle auf dem Prüfstand</h3>
      </div>
    </div>
  </div>
</section>

<!-- Inhalte -->
<section class="bg-grey py-5" aria-labelledby="inhalt-luftdichtheit">
  <div class="container" id="inhalt-luftdichtheit">
    <div class="row">
      <!-- Spalte 1 -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/icons/luftdichtheitsmessung-luftdichtheitstest.svg" class="img-fluid d-block mx-auto"  style="max-width: 50%;" alt="">
        </div>
        <ul>
          <li>Pflicht ist eine Luftdichtheitsmessung für KfW-geförderte Wohnungs-Neubauten.</li>
          <li>Gleiches gilt, wenn bei einer geförderten Modernisierung eine Lüftungsanlage eingebaut wird.</li>
          <li>Oder auf KfW-Effizienzhausniveau modernisiert wird.</li>
        </ul>
      </div>

      <!-- Spalte 2 -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/icons/luftdichtheitsmessung-leistungen-im-ueberblick.svg" class="img-fluid d-block mx-auto"  style="max-width: 50%;" alt="">
        </div>
        <ul>
          <li>Prüfung der Luftdichtigkeit gemäß Anforderungen nach DIN 4108-7, EN 13829, Passivhaus Institut Darmstadt</li>
          <li>Suche und Kennzeichnung von Leckagen zur Behebung durch den Handwerker</li>
          <li>Dokumentation und Auswertung der Probenahme und der Messergebnisse</li>
          <li>Aushändigung eines Dichtheitszertifikats</li>
        </ul>
      </div>

      <!-- Spalte 3 -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/icons/luftdichtheitsmessung-kontakieren-sie-uns.svg" class="img-fluid d-block mx-auto"  style="max-width: 50%;" alt="">
        </div>
        <p>Ihre Luftdichtheitsmessung durch einen Fachmann können Sie einfach über die Fördergeld-Hotline oder per Kontaktformular anfordern. Anhand Ihres Wohnortes ermitteln wir einen Energieberater in Ihrer Nähe.</p>
        <h3 class="mt-3"><strong><i class="fa fa-phone" style="color: #9E0100;"></i>&nbsp;06190 9263-487</strong></h3>
        <p>werktags von 9 Uhr bis 17 Uhr</p>
        <div class="text-center">
          <a href="Kontakt" class="btn btn-warning">
            <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Messung hier anfordern</strong>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Messverfahren -->
<section class="py-5" aria-labelledby="messverfahren-ueberschrift">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h1 id="messverfahren-ueberschrift">So funktioniert die Messung</h1>
        <h4>Bei einer Luftdichtheitsmessung steht die sogenannte Luftdichtheitsebene der Gebäudehülle auf dem Prüfstand.</h4>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <p>Mittels eines speziellen Prüfgeräts werden per Über- bzw. Unterdruck eventuelle Leckagen anhand messbarer Luftströme an undichten Bauteilanschlüssen nachgewiesen und mittels künstlichem Nebel sichtbar gemacht. Der Test dauert bei einem Einfamilienhaus ca. drei Stunden. Als Grundlage für seine Berechnung benötigt der Fachmann alle gebäudespezifischen Angaben über das beheizte Raumvolumen, die beheizte Grundfläche, und die beheizte Hüllfläche.</p>
      </div>
    </div>
  </div>
</section>

<!-- Altbau/Neubau Vergleich -->
<section class="py-5" aria-labelledby="vergleich-ueberschrift">
  <div class="container" id="vergleich-ueberschrift">
    <div class="row">
      <div class="col-md-4 border-end">
        <h3><strong>Luftdichtheitsmessung im Altbau</strong></h3>
        <ul>
          <li>vor geplanter Modernisierung zur Feststellung des Ist-Zustands</li>
          <li>nach Durchführung der Modernisierung</li>
          <li>insbesondere für ein Effizienzhaus und nach Einbau einer Lüftungsanlage zur Qualitätskontrolle und Erfüllung der Voraussetzung für eine KfW-Förderung</li>
        </ul>
      </div>
      <div class="col-md-4">
        <h3><strong>Luftdichtheitsmessung im Neubau</strong></h3>
        <ul>
          <li>erste Messung vor Beginn des Innenausbaus zur Qualitätssicherung der fachgerechten Ausführung aller, für eine Nachbesserung noch frei zugängiger Anschlüsse</li>
          <li>zweite Messung nach Fertigstellung</li>
        </ul>
      </div>
      <div class="col-md-4 border-start">
        <h3><strong>Das bringt eine Messung</strong></h3>
        <p>In der Luftdichtheitsmessung erkannte Leckagen können anschließend gezielt durch den Fachhandwerker behoben werden.</p>
        <p>Das wirkt sich positiv auf die zukünftigen Einsparungen bei Energie und Kosten sowie den Wohnkomfort aus.</p>
      </div>
    </div>
  </div>
</section>

<!-- Energieberater Info -->
<section class="py-5" aria-labelledby="berater-ueberschrift">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h1 id="berater-ueberschrift">Professionelle Energieberater</h1>
      </div>
    </div>

    <div class="row">
      <div class="col-md-2"></div>
      <div class="col-md-8">
        <p>Damit Sie Ihre Vorhaben sowohl mit der bestmöglichen Energieeinsparung als auch der maximalen Förderung umsetzen können, arbeiten wir mit unabhängigen Energieberatern zusammen.</p>
      </div>
      <div class="col-md-2"></div>
    </div>

    <div class="row pt-4">
      <div class="col-md-4">
        <h3><strong>Schritt 1</strong></h3>
        <ul>
          <li>Ihre Anfrage über das Formular ist unverbindlich</li>
          <li>Erst wenn Sie unser Angebot bestätigen, starten wir mit Ihrem Sanierungsfahrplan</li>
          <li>Wir beantragen den Beratungszuschuss für Ihren Sanierungsfahrplan</li>
        </ul>
      </div>
      <div class="col-md-4 border-start border-end">
        <h3><strong>Schritt 2</strong></h3>
        <ul>
          <li>Ihr Gebäude kommt auf dem Prüfstand</li>
          <li>Ihr Sanierungsfahrplan wird erstellt</li>
          <li>Fertig &ndash; Sie halten den Sanierungsfahrplan in Ihren Händen</li>
          <li>Ihr persönliches Abschlussgespräch mit unserem Energieeffizienz-Experten</li>
        </ul>
      </div>
      <div class="col-md-4">
        <h3><strong>Schritt 3</strong></h3>
        <ul>
          <li>Modernisierungsschritte angehen</li>
          <li>5% höhere BEG-Förderung für anstehende Effizienzmaßnahmen nutzen</li>
        </ul>
      </div>
    </div>
  </div>
</section>
