<!-- Initialberatung Einleitung -->
<section class="py-5" aria-labelledby="initialberatung-ueberschrift">
  <div class="container">
    <div class="row">
      <div class="col-12 text-center">
        <h1 id="initialberatung-ueberschrift" class="text-uppercase">Initialberatung</h1>
        <h3>Beratung durch einen unabhängigen Energieberater vor Ort.</h3>
      </div>
    </div>
  </div>
</section>

<!-- Initialberatung Inhalt -->
<section class="bg-grey py-5" aria-labelledby="beratung-leistungen-anfordern">
  <div class="container">
    <div class="row" id="beratung-leistungen-anfordern">

      <!-- Persönliche Beratung -->
      <article class="col-md-4" aria-labelledby="beratung-persoenlich">
        <div class="text-center mb-3">
          <img src="pix/icons/energieberatung-initialberatung-persoenliche-beratung.svg" class="img-fluid d-block mx-auto"  style="max-width: 50%;"  alt="Icon Energieberater">
        </div>
        <p>Diese Initialberatung gibt dem Hauseigentümer eine erste Orientierung über energetische Schwachstellen und sinnvolle Maßnahmen.</p>
        <p>Die Beratung ist sinnvoll, wenn Sie:</p>
        <ul>
          <li>Energie und Energiekosten einsparen wollen</li>
          <li>Energieschwachstellen und Einsparpotenziale im Haus ausmachen wollen</li>
          <li>einen Überblick über den Umfang und die nötigen Investitionen gewinnen wollen</li>
          <li>anstehende Instandsetzungsarbeiten planen</li>
        </ul>
      </article>

      <!-- Leistungen im Überblick -->
      <article class="col-md-4" aria-labelledby="beratung-leistungen">
        <div class="text-center mb-3">
          <img src="pix/icons/energieberatung-initialberatung-leistungen-im-ueberblick.svg" class="img-fluid d-block mx-auto"  style="max-width: 50%;"  alt="Icon Checkliste">
        </div>
        <ul>
          <li>zweistündige Begehung mit einem versierten Energieberater</li>
          <li>Ermittlung sinnvoller energetischer Modernisierungsmöglichkeiten</li>
          <li>Ermittlung der potentiellen Fördermöglichkeiten</li>
          <li>Bereitstellung eines Ergebnisreports</li>
        </ul>
      </article>

      <!-- Initialberatung anfordern -->
      <article class="col-md-4" aria-labelledby="beratung-anfordern">
        <div class="text-center mb-3">
          <img src="pix/icons/energieberatung-initialberatung-kontakieren-sie-uns.svg" class="img-fluid d-block mx-auto"  style="max-width: 50%;"  alt="Icon Rückruf">
        </div>
        <p>Ihre Initialberatung können Sie einfach über die Fördergeld-Hotline oder per Kontaktformular anfordern. Anhand Ihres Wohnortes ermitteln wir einen Energieberater in Ihrer Nähe.</p>
        <p>Rufen Sie uns unter der kostenlosen Hotline an:</p>
        <h3 class="text-center text-danger"><strong><i class="fa fa-phone" aria-hidden="true"></i>&nbsp;06190 9263-487</strong></h3>
        <p class="text-center">werktags von 9 Uhr bis 17 Uhr</p>
        <div class="text-center">
          <a href="Kontakt" class="btn btn-warning">
            <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Initialberatung hier anfordern</strong>
          </a>
        </div>
      </article>

    </div>
  </div>
</section>

<!-- Schritte Sanierungsfahrplan -->
<section class="py-5" aria-labelledby="schritte-fahrplan">
  <div class="container">
    <div class="row">
      <div class="col-12 text-center">
        <h1 id="schritte-fahrplan">Professionelle Energieberater</h1>
      </div>
    </div>

    <div class="row">
      <div class="col-md-2"></div>
      <div class="col-md-8 text-center">
        <p>Damit Sie Ihre Vorhaben sowohl mit der bestmöglichen Energieeinsparung als auch der maximalen Förderung umsetzen können, arbeiten wir mit unabhängigen Energieberatern zusammen.</p>
      </div>
      <div class="col-md-2"></div>
    </div>

    <div class="row mt-5" aria-label="Ablauf">
      <!-- Schritt 1 -->
      <article class="col-md-4" role="listitem">
        <h3><strong>Schritt 1</strong></h3>
        <ul>
          <li>Ihre Anfrage über das Formular ist unverbindlich</li>
          <li>Erst wenn Sie unser Angebot bestätigen, starten wir mit Ihrem Sanierungsfahrplan</li>
          <li>Wir beantragen den Beratungszuschuss für Ihren Sanierungsfahrplan</li>
        </ul>
      </article>

      <!-- Schritt 2 -->
      <article class="col-md-4 border-start border-end" role="listitem">
        <h3><strong>Schritt 2</strong></h3>
        <ul>
          <li>Ihr Gebäude kommt auf den Prüfstand</li>
          <li>Ihr Sanierungsfahrplan wird erstellt</li>
          <li>Sie erhalten Ihren Fahrplan in Händen</li>
          <li>Persönliches Abschlussgespräch mit unserem Energieeffizienz-Experten</li>
        </ul>
      </article>

      <!-- Schritt 3 -->
      <article class="col-md-4" role="listitem">
        <h3><strong>Schritt 3</strong></h3>
        <ul>
          <li>Modernisierungsschritte angehen</li>
          <li>5&nbsp;% höhere BEG-Förderung für anstehende Effizienzmaßnahmen nutzen</li>
        </ul>
      </article>
    </div>
  </div>
</section>
