<section aria-labelledby="aktuelles-ueberschrift" class="py-5">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center text-uppercase">
        <h1 id="aktuelles-ueberschrift">Aktuelles</h1>
      </div>
    </div>

    <div class="row mt-4" role="list" aria-label="Aktuelle Fördermeldungen">

      <?php foreach ($news as $index => $item): ?>
        <?php
          $id = intval($item['id']);
          $subheadline = htmlspecialchars($item['subheadline']);
          $altText = htmlspecialchars($item['alt_text']);
          $text = $item['text'];
          $date = htmlspecialchars($item['date']); // Format bereits in DD.MM.YYYY
          $imgUrl = "getNewsImage.php?id=" . $id;
	?>
        <article class="col-md-4" role="listitem">
          <div class="panel panel-primary">
            <div class="panel-body p-0" style="overflow: hidden;">
              <a href="Details?id=<?php echo $id; ?>" class="zoom-wrapper" title="<?php echo $subheadline; ?>">
                <img src="<?php echo $imgUrl; ?>" alt="<?php echo $altText; ?>" />
                <span class="visually-hidden">Zur Nachricht: <?php echo $subheadline; ?></span>
              </a>
			  <?php
				setlocale(LC_TIME, 'de_DE.UTF-8'); // für Linux/macOS
				// setlocale(LC_TIME, 'deu'); // für Windows

				$dateObj = DateTime::createFromFormat('d.m.Y', $item['date']);
				$formattedDate = strftime('%A, %e. %B %Y', $dateObj->getTimestamp());
				?>
              <p class="small m-3"><?php echo $formattedDate; ?></p>
              <p class="m-3" style="min-height: 150px;">
				<?php
				$plainText = strip_tags($text);                 // HTML-Tags entfernen
				$plainText = str_replace(["\r", "\n"], ' ', $plainText); // Zeilenumbrüche entfernen
				$plainText = trim(preg_replace('/\s+/', ' ', $plainText)); // doppelte Leerzeichen bereinigen
				$shortText = mb_strlen($plainText) > 50 ? mb_substr($plainText, 0, 300) . '...' : $plainText;
				?>
                <?php echo $shortText; ?>
              </p>
            </div>
            <div class="panel-footer text-uppercase">
              <a href="Details?id=<?php echo $id; ?>" title="<?php echo $subheadline; ?>">
                <i class="fa fa-arrow-right" aria-hidden="true"></i>
                <span class="visually-hidden">Zur Nachricht: </span>
                weiter lesen
              </a>
            </div>
          </div>
        </article>
      <?php endforeach; ?>

    </div>
  </div>
</section>
