<?php
require_once 'auth.php';
header('Content-Type: application/json');

try {
    $db = new PDO('sqlite:' . __DIR__ . '../../data/database.sqlite');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $input = json_decode(file_get_contents('php://input'), true);
    $id = isset($input['id']) ? intval($input['id']) : 0;

    if ($id > 0) {
        $stmt = $db->prepare("DELETE FROM customers WHERE id = :id");
        $stmt->execute([':id' => $id]);

        echo json_encode(['success' => true]);
    } else {
        throw new Exception("Ungültige ID");
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
