<?php 


$page = isset($_GET["page"]) ? $_GET["page"] : "index.php" ;

$pageContent = "content-blocks/home.php";
if($page=="Impressum") $pageContent = "content-blocks/impressum.php";
if($page=="Datenschutz") $pageContent = "content-blocks/datenschutz.php";
if($page=="AGB") $pageContent = "content-blocks/agb.php";

?>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <title>Städtische Sparkasse Offenbach a. M. - Förderauskunft</title>
  <meta name="robots" content="index,follow" />
  <meta name="description" content="" />
  <meta name="keywords" content="" />
    <meta name="febis-questionizer-config-url" content="https://questionizer.foerdermittelauskunft.de/de/spk_offenbach/client-config.json" />
  <!-- Styles -->
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/awesome/css/font-awesome.min.css">
  <link rel="stylesheet" href="font.css">
  <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.css" />
  <script type="module" crossorigin src="https://questionizer.foerdermittelauskunft.de/de/spk_offenbach/assets/index.js"></script>
  <link rel="stylesheet" crossorigin href="https://questionizer.foerdermittelauskunft.de/de/spk_offenbach/assets/index.css">

     <script type="module" crossorigin src="https://esr.fe-bis.de/de/sparkasse_offenbach/assets/index.js"></script>
    <link rel="stylesheet" crossorigin href="https://esr.fe-bis.de/de/sparkasse_offenbach/assets/index.css">

<script src="https://cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.js"></script>
<script>
window.addEventListener("load", function () {
  window.cookieconsent.initialise({
    palette: {
      popup: {
        background: "#000"
      },
      button: {
        background: "#ff0000",
        text: "#fff"
      }
    },
    content: {
      message: "Diese Website verwendet nur funktional notwendige Cookies. Mehr Informationen ...",
      dismiss: "Verstanden",
      link: "Datenschutz",
      href: "https://www.sparkasse-offenbach.de/de/home/toolbar/datenschutz.html?n=true&stref=footer"
    },
    elements: {
      popup: '<div role="dialog" aria-label="Cookiehinweis" class="cc-window {{classes}}">{{message}}{{compliance}}</div>',
      dismiss: '<button type="button" class="cc-btn cc-dismiss" aria-label="Verstanden">{{dismiss}}</button>'
    },
    onInitialise: function () {
      const btn = document.querySelector('.cc-dismiss');
      if (btn) btn.focus(); 
    }
  });
});
</script>
</head>

<body>

  <!-- Skiplink -->
  <a class="visually-hidden-focusable" href="#main-content">Zum Inhalt springen</a>

  <!-- Header mit Logo/Bild -->
  <header class="panel-opener" role="banner">
    <img src="pix/header-spk-offenbach.jpg"
         class="img-fluid w-100"
         alt=""
         aria-hidden="true">
  </header>

  <!-- Hauptinhalt -->
  <main id="main-content" class="container my-5" role="main" tabindex="-1">
    <section aria-labelledby="questionizer-titel">
      <h1 id="questionizer-titel" class="visually-hidden">SPK Offenbach – Förderauskunft</h1>
      <div class="row">
        <div class="col-12">
          <?php include($pageContent); ?>
        </div>
      </div>
    </section>
  </main>

  <!-- Footer mit Links -->
<footer class="panel-footer text-white py-5" role="contentinfo">
  <div class="container">

    <!-- Service-Center -->
    <section class="row text-center mb-5" aria-labelledby="ksc-headline">
      <div class="col-12">
        <h2 id="ksc-headline" class="hl-3 color--white">KundenServiceCenter</h2>
        <p class="h2 color--white">069/8067-1</p>
        <p class="color--white mb-0">
          Montag – Donnerstag 8:00 – 18:00 Uhr, Freitag 8:00 – 16:00 Uhr
        </p>
      </div>
    </section>

    <!-- Kontakt-Icons -->
    <section class="row text-center g-4 mb-5" aria-labelledby="kontakt-headline">
      <h2 id="kontakt-headline" class="visually-hidden">Kontakt und Services</h2>

      <div class="col-12 col-sm-3">
        <a href="https://www.sparkasse-offenbach.de/de/home/onlinebanking/e_postfach/Nachricht-schreiben.html"
           target="_blank" rel="noreferrer"
           aria-label="Kontakt – Nachricht schreiben (öffnet in neuem Fenster)">
          <img src="pix/nachricht-schreiben.jpg" class="img-fluid" style="max-width:65px;" alt="">
        </a>
        <p class="fw-bold fs-5 mt-3 color--white">Kontakt</p>
      </div>

      <div class="col-12 col-sm-3">
        <a href="https://app2.sparkassen-chat.de/if6?blz=50550020"
           target="_blank" rel="noreferrer"
           aria-label="Beraterchat starten (öffnet in neuem Fenster)">
          <img src="pix/chat-starten.jpg" class="img-fluid" style="max-width:65px;" alt="">
        </a>
        <p class="fw-bold fs-5 mt-3 color--white">Beraterchat starten</p>
      </div>

      <div class="col-12 col-sm-3">
        <a href="https://www.sparkasse-offenbach.de/de/home/privatkunden/immobilien.html#berater"
           target="_blank" rel="noreferrer"
           aria-label="Immobilie verkaufen – Termin vereinbaren (öffnet in neuem Fenster)">
          <img src="pix/termin-vereinbaren.jpg" class="img-fluid" style="max-width:65px;" alt="">
        </a>
        <p class="fw-bold fs-5 mt-3 color--white">Immobilie verkaufen</p>
      </div>

      <div class="col-12 col-sm-3 text-sm-start text-center">
        <p class="fs-5 mb-2 color--white" id="spk-headline">Ihre Sparkasse</p>
        <nav aria-labelledby="spk-headline">
          <ul class="list-unstyled mb-0">
            <li><a class="link-light d-inline-flex mb-2"
                   href="https://www.sparkasse-offenbach.de/de/home/ihre-sparkasse/ihre-sparkasse-vor-ort.html"
                   target="_blank" rel="noreferrer">Über uns<span class="visually-hidden"> (öffnet in neuem Fenster)</span></a></li>
            <li><a class="link-light d-inline-flex mb-2"
                   href="https://www.sparkasse-offenbach.de/de/home/service/filiale-finden.html"
                   target="_blank" rel="noreferrer">Filiale finden<span class="visually-hidden"> (öffnet in neuem Fenster)</span></a></li>
            <li><a class="link-light d-inline-flex"
                   href="https://www.sparkasse-offenbach.de/de/home/service.html"
                   target="_blank" rel="noreferrer">Service-Center<span class="visually-hidden"> (öffnet in neuem Fenster)</span></a></li>
          </ul>
        </nav>
      </div>
    </section>

    <!-- Footer Bottom -->
    <section class="row align-items-center" aria-label="Rechtliches und Logo">
      <div class="col-12 col-md-9 mb-3 mb-md-0">
        <a href="https://www.sparkasse-offenbach.de/de/home/toolbar/impressum.html?n=true&stref=footer"
           class="link-light me-4" target="_blank" rel="noreferrer">Impressum<span class="visually-hidden"> (öffnet in neuem Fenster)</span></a>
        <a href="https://www.sparkasse-offenbach.de/de/home/toolbar/datenschutz.html?n=true&stref=footer"
           class="link-light" target="_blank" rel="noreferrer">Datenschutz<span class="visually-hidden"> (öffnet in neuem Fenster)</span></a>
      </div>
      <div class="col-12 col-md-3 text-md-end text-center">
        <img src="pix/logo-spk-offenbach-weiss.png" class="img-fluid" style="max-width:200px;" alt="Städtische Sparkasse Offenbach am Main – Logo">
      </div>
    </section>

  </div>
</footer>


<script>
(function () {
  function isVisible(el) {
    return !!(el && (el.offsetWidth || el.offsetHeight || el.getClientRects().length));
  }

  const reduceMotion = window.matchMedia('(prefers-reduced-motion: reduce)').matches;
  const userHasHash = location.hash && location.hash !== '#top' && location.hash !== '#main-content';
  let userInteracted = false;

  ['scroll', 'keydown', 'pointerdown', 'touchstart'].forEach(evt => {
    window.addEventListener(evt, () => { userInteracted = true; }, { once: true, passive: true });
  });

  function scrollToMain() {
    const main = document.getElementById('main-content');
    if (!main) return;


    const ae = document.activeElement;
    if (ae && (ae.tagName === 'INPUT' || ae.tagName === 'TEXTAREA' || ae.isContentEditable)) return;

    if (!main.hasAttribute('tabindex')) main.setAttribute('tabindex', '-1');
    main.focus({ preventScroll: true });

    if (!reduceMotion && 'scrollBehavior' in document.documentElement.style) {
      main.scrollIntoView({ behavior: 'smooth', block: 'start' });
    } else {
      main.scrollIntoView(); 
    }
  }

  window.addEventListener('load', function () {
    setTimeout(function () {
      if (userHasHash || userInteracted) return;

      const banner = document.querySelector('.cc-window');
      const dismiss = document.querySelector('.cc-dismiss');

      if (banner && isVisible(banner)) {
        
        if (dismiss) {
          const handler = () => { setTimeout(scrollToMain, 200); };
          dismiss.addEventListener('click', handler, { once: true });
        } else {
          const obs = new MutationObserver(() => {
            if (!isVisible(banner)) { obs.disconnect(); scrollToMain(); }
          });
          obs.observe(banner, { attributes: true, attributeFilter: ['style', 'class'] });
        }
      } else {
        scrollToMain();
      }
    }, 3000);
  });
})();
</script>

  <!-- JavaScript -->
  <script src="js/bootstrap.bundle.min.js"></script>

</body>
</html>
