<?php
ini_set('display_errors', '0');
ini_set('soap.wsdl_cache_enabled', '1');
require "defs.php";

$id = null;
$uid = null;
$partner = null;
$partnerMail = null;
$partnerContact = null;
$partnerAddress = null;
$partnerZip = null;
$partnerCity = null;
$partnerTextOptional = null;
$partnerTel = null;
$partnerFax = null;
$partnerTheme = null;
$partnerNavi = null;
$partnerShowPrint = null;
$partnerFreiText = null;

$sess_id = sess_id;

$page = $_GET["page"];
if (isset($_GET["uid"]) || isset($_GET["action"])) {
    $uid = isset($_GET["uid"]) ? $_GET["uid"] : $_GET["action"];
}

if(!$uid){
	$uid = isset($_SESSION["uid"]) ? $_SESSION["uid"] : null;
}

$db = new SQLite3(partnerDB);

$errorText = "";
if (isset($uid)) {		
		$partnerRes = $db->query("SELECT id,uid,firma,email,ansprechpartner, ansprechpartner_alt, funktion, funktion_alt,freitext, strasse,plz,ort,optional,telefon,fax,theme,navi,showPrint,click,active FROM customers WHERE uid='".$db->escapeString($uid)."'");
		$partnerRow = $partnerRes->fetchArray(SQLITE3_ASSOC);

		if($partnerRow["active"] != 1){
			$errorText =  "uid ist nicht freigegeben";
		}

		if (!empty($partnerRow)) {
			$id = $partnerRow["id"];		
			$uid = $partnerRow["uid"];
			$_SESSION["uid"] = $uid;
			$partner = $partnerRow["firma"];
			$partnerMail = $partnerRow["email"];
			$partnerContact = ( $partnerRow["ansprechpartner_alt"] )? $partnerRow["ansprechpartner_alt"] : $partnerRow["ansprechpartner"];
			$partnerFunktion = ( $partnerRow["funktion_alt"] )? $partnerRow["funktion_alt"] : $partnerRow["funktion"];
			$partnerAddress = $partnerRow["strasse"];
			$partnerZip = $partnerRow["plz"];
			$partnerCity = $partnerRow["ort"];
			$partnerTextOptional = $partnerRow["optional"];
			$partnerTel = $partnerRow["telefon"];
			$partnerFax = $partnerRow["fax"];
			$partnerTheme = $partnerRow["theme"];
			$partnerNavi = json_decode($partnerRow["navi"]);
			$partnerFreiText = $partnerRow["freitext"];
			$partnerShowPrint = $partnerRow["showPrint"];
			$newclick =  intval($partnerRow["click"]) + 1;
			
			$partnerRes = $db->query("Update customers set click = ".$newclick." WHERE uid='".$uid."'");
		} else {
			$errorText = "uid ist nicht existiert"; 
		}
}else{
	$errorText = "Bitte starten Sie die Anwendung mit den richtigen Parameter neu"; 
}

$news = [];
$newsRes = $db->query("SELECT id, title, date, subheadline, alt_text, text, image_credit FROM news WHERE active = 1 ORDER BY substr(date, 7, 4) || '-' || substr(date, 4, 2) || '-' || substr(date, 1, 2) DESC");
while ($row = $newsRes->fetchArray(SQLITE3_ASSOC)) {
  $news[] = $row;
}


$js[]="function MM_openBrWindow(theURL,winName,features, myWidth, myHeight, isCenter) { //v3.0
	if(window.screen)if(isCenter)if(isCenter==\"true\"){
		var myLeft = (screen.width-myWidth)/2;
		var myTop = (screen.height-myHeight)/2;
		features+=(features!='')?',':'';
		features+=',left='+myLeft+',top='+myTop;
	}
	window.open(theURL,winName,features+((features!='')?',':'')+'width='+myWidth+',height='+myHeight);
}";

							 
if($page=="Startseite"  || $page=="") $pageContent = "content-blocks/startseite.php";
if($page=="Foerderauskunft") $pageContent = "content-blocks/foerderauskunft.php";
if($page=="Foerderservice") $pageContent = "content-blocks/foerderservice.php";
if($page=="Foerdermoeglichkeiten") $pageContent = "content-blocks/foerdermoeglichkeiten.php";
if($page=="Aktuelles") $pageContent = "content-blocks/aktuelles.php";
if($page=="Details") $pageContent = "content-blocks/details.php";

if($page=="Impressum") $pageContent = "content-blocks/impressum.php";
if($page=="Datenschutz") $pageContent = "content-blocks/datenschutz.php";

$noFooterKontakt = array('Kontakt','Impressum','Datenschutz');
$onload[]="window.location.href = '#top';";

//$errorText = "";


echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="de" lang="de">
<head>
	<title>Roto - Das Dachfenster</title>
<meta charset="UTF-8" />
<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta name="robots" content="index, follow" />	
<meta name="plz" content="<?php echo $partnerZip ?>" />
<meta name="form_email_to" content="<?php echo $partnerMail ?>" />
<meta name="febis-questionizer-config-url" content="https://questionizer.foerdermittelauskunft.de/de/roto/client-config.json" />
<style>
:root {
  --primary-color: <?php echo $partnerTheme ? $partnerTheme : '#9E0100'; ?>;
}
</style>
<link rel="stylesheet" href="css/awesome/css/font-awesome.css" />
<link href="css/bootstrap.min.css" rel="stylesheet">
  
<link rel="stylesheet" type="text/css" href="font.css">
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.js"></script>
<script>
window.addEventListener("load", function () {
  window.cookieconsent.initialise({
    palette: {
      popup: {
        background: "#000"
      },
      button: {
        background: "<?php echo ($partnerTheme ? $partnerTheme : '#265db1');?>",
        text: "#fff"
      }
    },
    content: {
      message: "Diese Website verwendet nur funktional notwendige Cookies. Mehr Informationen ...",
      dismiss: "Verstanden",
      link: "Datenschutz",
      href: "index.php?page=Datenschutz"
    },
    elements: {
      popup: '<div role="dialog" aria-label="Cookiehinweis" class="cc-window {{classes}}">{{message}}{{compliance}}</div>',
      dismiss: '<button type="button" class="cc-btn cc-dismiss" aria-label="Verstanden">{{dismiss}}</button>'
    },
    onInitialise: function () {
      const btn = document.querySelector('.cc-dismiss');
      if (btn) btn.focus(); // optional für Tastatur
    }
  });
});
</script>

</head>
<body >
  <?php if(!$errorText): ?> 
	<a class="visually-hidden-focusable" href="#main-content">Zum Hauptinhalt springen</a>
	<!-- BARRIEREFREIES LAYOUT -->
	<div id="page-wrapper">
		<div role="banner">
		<?php include('header.php'); ?>
		</div>

		<main id="main-content" role="main" tabindex="-1">
		<?php include($pageContent); ?>
		</main>

		<div role="contentinfo">
			<?php include('footer.php'); ?>
		</div>
	</div>

	<!-- Session ID -->
	<?php echo hidden_sess_id; ?>
	<?php else: ?>
<div class="modal fade in" id="messageModal" tabindex="-1" role="dialog" aria-labelledby="meinKleinesModalLabel" style="display: block; padding-left: 0px;">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <h3 class="page-header text-uppercase">Herzlich Willkommen beim Roto FÖRDERSERVICE!</h3>
                                </div>
                            </div>

                            <p>&nbsp;</p>

                            <div class="row">
                                <div class="col-md-1"></div>
                                <div class="col-md-5">
                                    <div class="panel panel-primary">
                                        <div class="panel-body" style="overflow: hidden; padding: 0;">
                                            <a href="https://www.roto-dachfenster.de/foerderauskunft.html " id="ctl00_A21" title="Mehr erfahren">
                                                <img src="pix/foerdergeld-suche-400x400.jpg" class="img-responsive hover-effect" alt="Mehr erfahren" title="Mehr erfahren" style="width:100%;"></a>
                                        </div>
                                    </div>

                                    <div>
                                        <h4 class="text-uppercase text-center">Bauherren und Hauseigentümer</h4>
                                        <blockquote>Sie sind auf der Suche nach Fördergeldern für Ihre neuen Dachfenster? Dann sind Sie bei Roto genau richtig. Informieren Sie sich über Ihre Fördermöglichkeiten und nutzen Sie den Förderservice vom Roto-Fachbetrieb in Ihrer Nähe.</blockquote>
                                    </div>

                                    <div class="text-center"><a href="https://www.roto-dachfenster.de/foerderauskunft.html " class="btn btn-primary" title="zum Fördergeld" target="_blank"><span class="glyphicon glyphicon-new-window">&nbsp;</span>Mehr erfahren</a></div>
                                </div>
                                
                                <div class="col-md-5">
                                    <div class="panel panel-primary">
                                        <div class="panel-body" style="overflow: hidden; padding: 0;">
                                            <a href="http://newsletter.roto-dachfenster.de/f/120875-262471/" id="ctl00_A25" title="Zum Fördermittel-Service Newsletter anmelden">
                                                <img src="pix/mobilitaet-400x400.jpg" class="img-responsive hover-effect" alt="Zum Fördermittel-Service Newsletter anmelden" title="Zum Fördermittel-Service Newsletter anmelden" style="width:100%;"></a>
                                        </div>
                                    </div>

                                    <div>
                                        <h4 class="text-uppercase text-center">ROTO-FACHBETRIEB</h4>
                                        <blockquote>Mit Ihrer eigenen Fördergeld-Microsite informieren Sie Hauseigentümer online, den Einbau der neuen Dachfenster mit Ihnen als Fachbetrieb anzugehen. Den staatlichen Zuschuss von 15 % können Sie bequem über den Roto-Förderservice beantragen!</blockquote>
                                    </div>

                                    <div class="text-center active"><a href="http://newsletter.roto-dachfenster.de/f/120875-262471/" class="btn btn-primary" title="zur Fördergeld-Microsite" target="_blank"><span class="glyphicon glyphicon-new-window">&nbsp;</span>Zum Förderservice Newsletter anmelden</a></div>
                                </div>

                                <div class="col-md-1"></div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            
                        </div>
                    </div>
                </div>
            </div>
				<script type="text/javascript">
  window.addEventListener('DOMContentLoaded', function () {
    const modal = new bootstrap.Modal(document.getElementById('messageModal'), {
      backdrop: 'static',
      keyboard: false
    });
    modal.show();
  });
</script>
	<?php endif; ?>
</body>
<script src="js/bootstrap.bundle.min.js"></script>

</html>

