<?php

$naviItems = $partnerNavi;

if (!is_array($naviItems)) {
  $naviItems = [
    'foerderauskunft', 'foerderservice',
    'foerdermoeglichkeiten', 'aktuelles'
  ];
}

function isNavItemActive($key, $items) {
  return in_array($key, $items);
}
?>
<!-- Barrierefreier Bootstrap Header mit Logo über Navbar -->
<style>
  /* Für sichtbare Tastatur-Fokus-Indikatoren */
  a:focus-visible, button:focus-visible {
    outline: 3px solid #005fcc;
    outline-offset: 2px;
  }
</style>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const dropdowns = document.querySelectorAll('.navbar .dropdown');

    dropdowns.forEach(function (dropdown) {
      const toggle = dropdown.querySelector('.dropdown-toggle');
      const menu = dropdown.querySelector('.dropdown-menu');

      // Hover für große Bildschirme
      if (window.innerWidth >= 992) {
        dropdown.addEventListener('mouseenter', function () {
          toggle.classList.add('show');
          toggle.setAttribute('aria-expanded', 'true');
          menu.classList.add('show');
        });

        dropdown.addEventListener('mouseleave', function () {
          toggle.classList.remove('show');
          toggle.setAttribute('aria-expanded', 'false');
          menu.classList.remove('show');
        });
      }

      // Tastatur: Dropdown per Enter oder Space öffnen/schließen
      toggle.addEventListener('keydown', function (e) {
        if (e.key === 'Enter' || e.key === ' ') {
          e.preventDefault();
          const isOpen = menu.classList.contains('show');
          toggle.setAttribute('aria-expanded', String(!isOpen));
          menu.classList.toggle('show');
        }
      });
    });
  });
</script>
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const path = window.location.pathname;

    // Alle Nav-Links durchgehen
    document.querySelectorAll(".navbar-nav .nav-link, .navbar-nav .dropdown-item").forEach(link => {
      const href = link.getAttribute("href");
      if (path.includes(href)) {
        link.classList.add("active");

        // Auch das übergeordnete <li> mit Dropdown-Link markieren
        const parentDropdown = link.closest(".dropdown-menu")?.previousElementSibling;
        if (parentDropdown) {
          parentDropdown.classList.add("active");
        }
      }
    });
  });
</script>
<header class="bg-white no-fixed-header" role="banner">
  <div class="logo-wrapper container py-2 d-flex justify-content-between align-items-center" style="height: 100px;">
	<!-- Linkes Logo -->
		<?php if($partner) : ?>
			<a href="." class="d-inline-block" aria-label="Zur Startseite">												
				<img class="logo" style="border-width:0px;" alt="Logo" title="logo" src="getLogo.php?uid=<?php echo urlencode($uid);?>">							
			</a>
	  <?php else: ?>
			<a href="." class="d-inline-block" aria-label="Zur Startseite">												
				<img class="logo" style="border-width:0px;" alt="Logo" title="logo" src="pix/logo-roto.png">							
			</a>			  
	  <?php endif;?>
				
    <!-- Rechtes Logo -->
    <a href="#" class="d-inline-block" aria-label="Roto">
      <img src="pix/logo-roto.jpg" alt="Logo rechts" style="max-height: 60px;">
    </a>
  </div>

  <nav class="navbar navbar-expand-lg navbar-roto pt-0 pb-0" role="navigation" aria-label="Hauptnavigation">
    <div class="container">
      <a class="navbar-brand" href="./"><?php echo $partner ?></a>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar"
        aria-controls="mainNavbar" aria-expanded="false" aria-label="Navigation ein-/ausklappen">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="mainNavbar">
        <ul class="navbar-nav ms-auto mb-2 mb-lg-0">

     <li class="nav-item">
      
        <a class="nav-link" role="menuitem" href="Startseite">
          <i class="fa fa-home" aria-hidden="true"></i>
          STARTSEITE
        </a>
      </li>

  <!-- FÖRDERAUSKUNFT-->
    <?php if (isNavItemActive('foerderauskunft', $naviItems)): ?>
      <li class="nav-item">
        <a class="nav-link" role="menuitem" href="Foerderauskunft">
          FÖRDERAUSKUNFT
        </a>
      </li>
    <?php endif; ?>

  <!-- FÖRDERSERVICE-->
    <?php if (isNavItemActive('foerderservice', $naviItems)): ?>
      <li class="nav-item">
        <a class="nav-link" role="menuitem" href="Foerderservice">
          FÖRDERSERVICE
        </a>
      </li>
    <?php endif; ?>
  
      <!-- FÖRDERMÖGLICHKEITEN-->
    <?php if (isNavItemActive('foerdermoeglichkeiten', $naviItems)): ?>
      <li class="nav-item">
        <a class="nav-link" role="menuitem" href="Foerdermoeglichkeiten">
          FÖRDERMÖGLICHKEITEN
        </a>
      </li>
    <?php endif; ?>

      <!-- AKTUELLES-->
    <?php if (isNavItemActive('aktuelles', $naviItems)): ?>
      <li class="nav-item">
        <a class="nav-link" role="menuitem" href="Aktuelles">
          AKTUELLES
        </a>
      </li>
    <?php endif; ?>

</ul>

      </div>
    </div>
  </nav>
</header>