<?php 

header('Location: https://www.foerdermittelauskunft.de/extern/evh_fach');
exit;

$page = isset($_GET["page"]) ? $_GET["page"] : "home";
$pageContent = "content-blocks/home.php";

if($page=="Foerderung") $pageContent = "content-blocks/home.php";
if($page=="Impressum") $pageContent = "content-blocks/impressum.php";
if($page=="Datenschutz") $pageContent = "content-blocks/datenschutz.php";
if($page=="GebaeudeCheck") $pageContent = "content-blocks/gebaeudecheck.php";

?>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fördermittelauskunft</title>

  <!-- Bootstrap CSS -->
  <link href="css/bootstrap.min.css" rel="stylesheet">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="css/awesome/css/font-awesome.css" />

  <!-- Questionizer Config -->
  <meta name="febis-questionizer-config-url" content="https://questionizer.foerdermittelauskunft.de/de/evh2/client-config.json" />

  <!-- eigenes CSS -->
  <link rel="stylesheet" href="font.css">
</head>
<body id="top">

<!-- Skiplink für Screenreader -->
<a class="visually-hidden-focusable" href="#main">Zum Inhalt springen</a>

<!-- Header -->
<header class="border-bottom top_wrap" role="banner">
  <div class="container d-flex justify-content-between align-items-center py-2">

    <!-- Logo -->
    <div class="logo">
        <img src="pix/logo.png" alt="Logo EVH" class="img-fluid" style="max-height:60px;">
    </div>

    <!-- Navbar mit Offcanvas -->
    <nav class="navbar navbar-expand-lg navbar-light" role="navigation" aria-label="Hauptmenü">
      <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#mainMenu"
        aria-controls="mainMenu" aria-expanded="false" aria-label="Menü öffnen">
        <span class="navbar-toggler-icon"></span>
      </button>

      <!-- Offcanvas Container -->
      <div class="offcanvas offcanvas-end" tabindex="-1" id="mainMenu" aria-labelledby="mainMenuLabel">
        <div class="offcanvas-header">
          <h2 class="offcanvas-title h5" id="mainMenuLabel">Menü</h2>
          <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Menü schließen"></button>
        </div>
        <div class="offcanvas-body">
          <ul class="navbar-nav ms-auto">
            <li class="nav-item">
              <a class="nav-link <?php echo ($page=="Foerderung" ? 'active':'')?>" href="index.php?page=Foerderung">Förderung</a>
            </li>
            <li class="nav-item">
              <a class="nav-link <?php echo ($page=="GebaeudeCheck" ? 'active':'')?>" href="index.php?page=GebaeudeCheck">GebäudeCheck</a>
            </li>
            <li class="nav-item">
              <a class="nav-link <?php echo ($page=="Datenschutz" ? 'active':'')?>" href="index.php?page=Datenschutz">Datenschutz</a>
            </li>
            <li class="nav-item">
              <a class="nav-link <?php echo ($page=="Impressum" ? 'active':'')?>" href="index.php?page=Impressum">Impressum</a>
            </li>
          </ul>
        </div>
      </div>
    </nav>

  </div>
</header>

<!-- Main -->
<main class="container my-2" id="main" role="main">
  <div id="mainResult" class="content">
  <div class="text-center mb-2"></div>
    <?php include($pageContent); ?>
  </div>
</main>

<?php if( $page=="Foerderung" || $page=="GebaeudeCheck") : ?>
  <footer class="text-center py-3 mb-4">
    <a
      href="https://evh.de/vorteils-und-wissenswelt/unternehmen/meilensteine-der-energie-waermewende"
      target="_blank"
      rel="noopener noreferrer"
      class="link text-decoration-none fw-medium"
    >
      <h3>Mehr Infos finden Sie hier</h3>
    </a>
  </footer>
<?php endif; ?>

<!-- Cookie Consent -->
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.css" />
<script src="//cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.js"></script>
<script>
window.addEventListener("load", function(){
  window.cookieconsent.initialise({
    "palette": {
      "popup": {"background": "#CCCCCC"},
      "button": {"background": "#000"}
    },
    "content": {
      "message": "Wir verwenden Cookies, um die Nutzerfreundlichkeit unserer Website zu verbessern. Mehr Informationen finden Sie unter ",
      "dismiss": "Verstanden",
      "href": "index.php?page=Datenschutz",
      "link": "Datenschutz"
    }
  })
});
</script>

<!-- Bootstrap Bundle -->
<script src="js/bootstrap.bundle.min.js"></script>

</body>
</html>
