<?php
ini_set('display_errors', '0');
ini_set('soap.wsdl_cache_enabled', '1');
require "defs.php";

$id = null;
$uid = null;
$partner = null;
$partnerMail = null;
$partnerContact = null;
$partnerAddress = null;
$partnerZip = null;
$partnerCity = null;
$partnerTextOptional = null;
$partnerTel = null;
$partnerFax = null;
$partnerTheme = null;
$partnerNavi = null;
$partnerShowPrint = null;
$partnerFreiText = null;
$partnerInfoHeader = null;
$partnerInfoLink =null;
$partnerInfoLinkText = null;
$partnerFromMailTo =null;

$sess_id = sess_id;

$page = $_GET["page"];
if (isset($_GET["uid"]) || isset($_GET["action"])) {
    $uid = isset($_GET["uid"]) ? $_GET["uid"] : $_GET["action"];
}

if(!$uid){
	$uid = isset($_SESSION["uid"]) ? $_SESSION["uid"] : null;
}

$db = new SQLite3(partnerDB);

$errorText = "";
if (isset($uid)) {		
		$partnerRes = $db->query("SELECT id,uid,firma,email,ansprechpartner, info_header, info_link, info_link_text, info_link_neu_window, from_mail_to, ansprechpartner_alt, funktion, funktion_alt,freitext, strasse,plz,ort,optional,telefon,fax,theme,navi,showPrint,click,active FROM customers WHERE uid='".$db->escapeString($uid)."'");
		$partnerRow = $partnerRes->fetchArray(SQLITE3_ASSOC);

		if($partnerRow["active"] != 1){
			$errorText =  "uid ist nicht freigegeben";
		}

		if (!empty($partnerRow)) {
			$id = $partnerRow["id"];		
			$uid = $partnerRow["uid"];
			$_SESSION["uid"] = $uid;
			$partner = $partnerRow["firma"];
			$partnerMail = $partnerRow["email"];
			$partnerContact = ( $partnerRow["ansprechpartner_alt"] )? $partnerRow["ansprechpartner_alt"] : $partnerRow["ansprechpartner"];
			$partnerFunktion = ( $partnerRow["funktion_alt"] )? $partnerRow["funktion_alt"] : $partnerRow["funktion"];
			$partnerAddress = $partnerRow["strasse"];
			$partnerZip = $partnerRow["plz"];
			$partnerCity = $partnerRow["ort"];
			$partnerTextOptional = $partnerRow["optional"];
			$partnerTel = $partnerRow["telefon"];
			$partnerFax = $partnerRow["fax"];

			$partnerInfoHeader = $partnerRow["info_header"];
			$partnerInfoLink = $partnerRow["info_link"];
			$partnerInfoLinkText = $partnerRow["info_link_text"];
			$partnerInfoLinkNeuWindow = $partnerRow["info_link_neu_window"];
			$partnerFromMailTo = $partnerRow["from_mail_to"];

			$partnerTheme = $partnerRow["theme"];
			$partnerNavi = json_decode($partnerRow["navi"]);
			$partnerFreiText = $partnerRow["freitext"];
			$partnerShowPrint = $partnerRow["showPrint"];
			$newclick =  intval($partnerRow["click"]) + 1;
			
			$partnerRes = $db->query("Update customers set click = ".$newclick." WHERE uid='".$uid."'");
		} else {
			$errorText = "uid ist nicht existiert"; 
		}
}else{
	$errorText = "Bitte starten Sie die Anwendung mit den richtigen Parameter neu"; 
}

$news = [];
$newsRes = $db->query("SELECT id, title, date, subheadline, alt_text, text, image_credit FROM news WHERE active = 1");
while ($row = $newsRes->fetchArray(SQLITE3_ASSOC)) {
  $news[] = $row;
}

							 
if($page=="Home"  || $page=="") $pageContent = "content-blocks/home.php";

if($page=="Foerdergeld-Suche") $pageContent = "content-blocks/foerdergeldsuche.php";
if($page=="Energiesparrechner") $pageContent = "content-blocks/energiesparrechner.php";

if($page=="Impressum") $pageContent = "content-blocks/impressum.php";
if($page=="Datenschutz") $pageContent = "content-blocks/datenschutz.php";

$noFooterKontakt = array('Impressum','Datenschutz');
$onload[]="window.location.href = '#top';";


echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="de" lang="de">
<head>
<?php if (!empty($partner)): ?>
	<title>Fördermittelauskunft - <?php echo ucfirst($partner);?></title>
<?php else: ?>
	<title>Fördermittelauskunft</title>
<?php endif; ?>
<meta charset="UTF-8" />
<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta name="robots" content="index, follow" />	
<meta name="febis-questionizer-config-url" content="https://questionizer.foerdermittelauskunft.de/de/eurobaustoff/client-config.json" />
<?php if($partnerFromMailTo): ?>
	<meta name="form_email_to" content="<?php echo $partnerFromMailTo ?>" />
<?php endif; ?>
<meta name="uid" content="<?php echo $uid ?>" />
<style>
:root {
  --primary-color: <?php echo $partnerTheme ? $partnerTheme : '#9E0100'; ?>;
}
</style>
<link rel="stylesheet" href="css/awesome/css/font-awesome.css" />
<link href="css/bootstrap.min.css" rel="stylesheet">
  
<link rel="stylesheet" type="text/css" href="font.css">
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.js"></script>
<script>
window.addEventListener("load", function () {
  window.cookieconsent.initialise({
    palette: {
      popup: {
        background: "#000"
      },
      button: {
        background: "<?php echo $partnerTheme;?>",
        text: "#fff"
      }
    },
    content: {
      message: "Diese Website verwendet nur funktional notwendige Cookies. Mehr Informationen ...",
      dismiss: "Verstanden",
      link: "Datenschutz",
      href: "index.php?page=Datenschutz"
    },
    elements: {
      popup: '<div role="dialog" aria-label="Cookiehinweis" class="cc-window {{classes}}">{{message}}{{compliance}}</div>',
      dismiss: '<button type="button" class="cc-btn cc-dismiss" aria-label="Verstanden">{{dismiss}}</button>'
    },
    onInitialise: function () {
      const btn = document.querySelector('.cc-dismiss');
      if (btn) btn.focus(); // optional für Tastatur
    }
  });
});
</script>

</head>
<body >
  <?php if(!$errorText): ?> 
	<a class="visually-hidden-focusable" href="#main-content">Zum Hauptinhalt springen</a>
	<!-- BARRIEREFREIES LAYOUT -->
	<div id="page-wrapper">
		<div role="banner">
		<?php include('header.php'); ?>
		</div>

		<main id="main-content" role="main" tabindex="-1">
		<?php include($pageContent); ?>
		</main>

		<div role="contentinfo">
			<?php include('footer.php'); ?>
		</div>
	</div>

	<!-- Session ID -->
	<?php echo hidden_sess_id; ?>
	<?php else: ?>
		<!-- Bootstrap 5 Modal -->
		<div class="modal fade" id="messageModal" tabindex="-1" aria-labelledby="messageModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg"> <!-- optional: modal-lg -->
			<div class="modal-content">
			<div class="modal-body">

				<img src="pix/header-sperrbildschirm.jpg" class="img-fluid mb-3" alt="Sperrbildschirm">

				<div class="text-dark px-2">
					<p>Hier sind Sie richtig.</p>
											<p>Auf dem Weg zu Ihrer regionalen Fördermittelauskunft – und besonders auch danach – kommen Sie am Fachhändler in Ihrer Nähe nicht vorbei. Er kann Ihnen bei Fragen aktiv helfen, empfiehlt Ihnen einen unabhängigen Energieberater als Unterstützung beim Förderantrag und bietet dann bei der eigentlichen Modernisierungsmaßnahme ein professionelles Baustoffsortiment, fundiertes Knowhow und konstruktiven Service.</p>
								
				</div>

				<div class="mt-4">
				<script src="//api.eurobaustoff.de/js/api.js" type="text/javascript"></script>
				<div data-eubmodule="widget" data-widget="locator" data-locator="febis"></div>
				</div>

			</div>
			</div>
		</div>
		</div>

	<script type="text/javascript">
  window.addEventListener('DOMContentLoaded', function () {
    const modal = new bootstrap.Modal(document.getElementById('messageModal'), {
      backdrop: 'static',
      keyboard: false
    });
    modal.show();
  });
</script>
	<?php endif; ?>
</body>
<script src="js/bootstrap.bundle.min.js"></script>

</html>

