<?php
ini_set('display_errors', '0');
header('Content-Type: application/json');

// Datenbankverbindung
try {
    $db = new PDO('sqlite:' . __DIR__ . '/admin/data/database.sqlite');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Datenbankfehler'
    ]);
    exit;
}

// UID validieren
$uid = $_GET['uid'] ?? '';
if (!$uid) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => 'Ungültige UID'
    ]);
    exit;
}

// Kundendaten abfragen
$stmt = $db->prepare("
    SELECT 
        firma, strasse, plz, ort, ansprechpartner, telefon, fax, email,
        info_header, info_link, info_link_text,
        freitext
    FROM customers
    WHERE uid = :uid AND active = 1
");
$stmt->execute([':uid' => $uid]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

// Ergebnis zurückgeben
if ($row) {
    echo json_encode([
        'success' => true,
        'contact' => $row
    ]);
} else {
    echo json_encode([
        'success' => false,
        'error' => 'Kein aktiver Eintrag gefunden'
    ]);
}
exit;
