import { defineConfig, loadEnv } from 'vite'
import vue from '@vitejs/plugin-vue'
import { viteStaticCopy } from 'vite-plugin-static-copy'
import path from 'path'

export default defineConfig(({ mode }) => {
  const env = loadEnv(mode, process.cwd())

  return {
    root: __dirname,
    base: env.VITE_BASE || '/',
    server: {
      proxy: {
        '/api': {
          target: env.VITE_API_PROXY,
          changeOrigin: true
        }
      }
    },
    build: {
      outDir: '../../frontend/'+env.VITE_CUSTOMER+'/admin',
      emptyOutDir: true,
      rollupOptions: {
        input: path.resolve(__dirname, 'index.html'),
        output: {
          entryFileNames: 'assets/[name].js',
          chunkFileNames: 'assets/[name].js',
          assetFileNames: 'assets/[name][extname]'
        }
      }
    },
    plugins: [vue(),
           viteStaticCopy({
  targets: [
    { src: 'api', dest: '.' },
    { src: '.htaccess', dest: '.' },
    { src: 'data', dest: '.' }
  ]
})
    ],
    resolve: {
      alias: {
        '@': path.resolve(__dirname, 'src')
      }
    }
  }
})