<?php
require_once 'auth.php';
header('Content-Type: application/json');

try {
    $db = new PDO('sqlite:' . __DIR__ . '../../data/database.sqlite');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // JSON-Daten parsen
    $jsonString = isset($_POST['json']) ? $_POST['json'] : '';
    $jsonData = json_decode($jsonString, true);
    if (!is_array($jsonData)) {
        throw new Exception('Ungültige JSON-Daten');
    }

    $id = isset($jsonData['id']) ? intval($jsonData['id']) : 0;
    $uid = isset($jsonData['uid']) ? trim($jsonData['uid']) : '';

    // Datei-Inhalte lesen
    $logoData = isset($_FILES['logo']) && is_uploaded_file($_FILES['logo']['tmp_name'])
        ? file_get_contents($_FILES['logo']['tmp_name'])
        : null;

    $passbildData = isset($_FILES['passbild']) && is_uploaded_file($_FILES['passbild']['tmp_name'])
        ? file_get_contents($_FILES['passbild']['tmp_name'])
        : null;

    $removePassbild = isset($_POST['removePassbild']) && $_POST['removePassbild'] === '1';

    $logoMimeType = null;
    $passbildMimeType = null;

    if ($logoData !== null) {
        $finfo = new finfo(FILEINFO_MIME_TYPE);
        $logoMimeType = $finfo->file($_FILES['logo']['tmp_name']);
    }

    if ($passbildData !== null) {
        $finfo = new finfo(FILEINFO_MIME_TYPE);
        $passbildMimeType = $finfo->file($_FILES['passbild']['tmp_name']);
    }


    if ($id > 0) {
        // UPDATE bestehender Datensatz
        $sql = "UPDATE customers SET
            firma = :firma,
            ansprechpartner = :ansprechpartner,
            funktion = :funktion,
            ansprechpartner_alt  = :ansprechpartner_alt ,
            funktion_alt  = :funktion_alt ,
            strasse = :strasse,
            plz = :plz,
            ort = :ort,
            optional = :optional,
            email = :email,
            telefon = :telefon,
            fax = :fax,
            createUser = :createUser,
            theme = :theme,
            navi = :navi,
            freitext  = :freitext ,
            showPrint = :showPrint";

        // Optional: Nur Logo aktualisieren wenn vorhanden
        if ($logoData !== null) {
            $sql .= ", logo = :logo, logo_mime_type = :logoMimeType";
        }

        if ($passbildData !== null) {
            $sql .= ", passbild = :passbild, passbild_mime_type = :passbildMimeType";
        } elseif ($removePassbild) {
            $sql .= ", passbild = NULL, passbild_mime_type = NULL";
        }

        $sql .= " WHERE id = :id";

        $stmt = $db->prepare($sql);

        $params = array(
            ':firma' => $jsonData['firma'],
            ':ansprechpartner' => $jsonData['ansprechpartner'],
            ':funktion' => $jsonData['funktion'],
            ':ansprechpartner_alt' => $jsonData['ansprechpartner_alt'],
            ':funktion_alt' => $jsonData['funktion_alt'],
            ':strasse' => $jsonData['strasse'],
            ':plz' => $jsonData['plz'],
            ':ort' => $jsonData['ort'],
            ':optional' => $jsonData['optional'],
            ':email' => $jsonData['email'],
            ':telefon' => $jsonData['telefon'],
            ':fax' => $jsonData['fax'],
            ':createUser' => $jsonData['createUser'],
            ':theme' => $jsonData['theme'],
            ':navi' => json_encode($jsonData['navi']),
            ':freitext' => $jsonData['freitext'],
            ':showPrint' => !empty($jsonData['showPrint']) ? 1 : 0,
            ':id' => $id
        );

        if ($logoData !== null) {
            $params[':logo'] = $logoData;
            $params[':logoMimeType'] = $logoMimeType;
        }

        if ($passbildData !== null) {
            $params[':passbild'] = $passbildData;
            $params[':passbildMimeType'] = $passbildMimeType;
        }

        $stmt->execute($params);

    } else {
        // INSERT
        if ($uid === '') {
            $uid = md5(uniqid(mt_rand(), true));
        }

        $stmt = $db->prepare("
            INSERT INTO customers (
                uid, firma, ansprechpartner, funktion, ansprechpartner_alt , funktion_alt , strasse, plz, ort, optional,
                email, telefon, fax, createUser, theme, navi, showPrint, logo, logo_mime_type, passbild, passbild_mime_type, active , freitext 
            ) VALUES (
                :uid, :firma, :ansprechpartner, :funktion, :ansprechpartner_alt , :funktion_alt , :strasse, :plz, :ort, :optional,
                :email, :telefon, :fax, :createUser, :theme, :navi, :showPrint, :logo, :logoMimeType, :passbild, :passbildMimeType, :active , :freitext
            )
        ");

        $stmt->execute(array(
            ':uid' => $uid,
            ':firma' => $jsonData['firma'],
            ':ansprechpartner' => $jsonData['ansprechpartner'],
            ':funktion' => $jsonData['funktion'],
            ':ansprechpartner_alt' => $jsonData['ansprechpartner_alt'],
            ':funktion_alt' => $jsonData['funktion_alt'],
            ':strasse' => $jsonData['strasse'],
            ':plz' => $jsonData['plz'],
            ':ort' => $jsonData['ort'],
            ':optional' => $jsonData['optional'],
            ':email' => $jsonData['email'],
            ':telefon' => $jsonData['telefon'],
            ':fax' => $jsonData['fax'],
            ':createUser' => $jsonData['createUser'],
            ':theme' => $jsonData['theme'],
            ':navi' => json_encode($jsonData['navi']),
            ':showPrint' => !empty($jsonData['showPrint']) ? 1 : 0,
            ':logo' => $logoData,
            ':logoMimeType' => $logoMimeType,
            ':passbild' => $passbildData,
            ':passbildMimeType' => $passbildMimeType,
            ':active' => 1,
            ':freitext' => $jsonData['freitext']
        ));
    }

    echo json_encode(array('success' => true));

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(array(
        'success' => false,
        'message' => $e->getMessage()
    ));
}
