<?php
if (!isset($_GET['id'])) {
    http_response_code(400);
    exit("ID fehlt");
}

try {
    $db = new PDO('sqlite:' . __DIR__ . '../../data/database.sqlite');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $db->prepare("SELECT image FROM news WHERE id = :id");
    $stmt->bindValue(':id', $_GET['id'], PDO::PARAM_INT);
    $stmt->execute();

    $image = $stmt->fetchColumn();

    if ($image) {
        header('Content-Type: image/jpeg'); // oder image/png je nach Format
        echo $image;
    } else {
        http_response_code(200);
        echo "Kein Bild gefunden";
    }
} catch (Exception $e) {
    http_response_code(500);
    echo "Fehler: " . $e->getMessage();
}
