<?php
require_once 'auth.php';
header('Content-Type: application/json');

try {
    $db = new PDO('sqlite:' . __DIR__ . '../../data/database.sqlite');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;

    if ($id > 0) {
        // Einzelner News-Eintrag
        $stmt = $db->prepare("
            SELECT id, title, date, subheadline, alt_text, image_credit, text, active
            FROM news
            WHERE id = :id order by date DESC
        ");
        $stmt->execute([':id' => $id]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $newsItem = array(
                'id' => $row['id'],
                'title' => $row['title'],
                'date' => $row['date'],
                'subheadline' => $row['subheadline'],
                'altText' => $row['alt_text'],
                'imageCredit' => $row['image_credit'],
                'text' => $row['text'],
                'active' => intval($row['active']),
                'imageUrl' => '/api/getNewsImage.php?id=' . $row['id']
            );

            echo json_encode(array(
                'success' => true,
                'item' => $newsItem,
                'fehler' => ''
            ));
        } else {
            echo json_encode(array(
                'success' => false,
                'item' => null,
                'fehler' => 'News-Eintrag nicht gefunden.'
            ));
        }
    } else {
        // Alle News-Einträge
        $result = $db->query("
            SELECT id, title, date, subheadline, alt_text, image_credit, text, active
            FROM news
            ORDER BY id DESC 
        ");

        $newsList = array();
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $newsList[] = array(
                'id' => $row['id'],
                'title' => $row['title'],
                'date' => $row['date'],
                'subheadline' => $row['subheadline'],
                'altText' => $row['alt_text'],
                'imageCredit' => $row['image_credit'],
                'text' => $row['text'],
                'active' => intval($row['active']),
                'imageUrl' => '/api/getNewsImage.php?id=' . $row['id']
            );
        }

        echo json_encode(array(
            'success' => true,
            'item' => $newsList,
            'fehler' => ''
        ));
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(array(
        'success' => false,
        'item' => null,
        'fehler' => $e->getMessage()
    ));
}
