// src/stores/auth.js
import { defineStore } from 'pinia'
import { ref, computed } from 'vue'
import router from '@/router'

const customer = import.meta.env.VITE_CUSTOMER || 'default'
const tokenKey = `token_${customer}`

export const useAuthStore = defineStore('auth', () => {
  const token = ref(localStorage.getItem(tokenKey) || null)

  const isLoggedIn = computed(() => !!token.value)

  function login(newToken) {
    token.value = newToken
    localStorage.setItem(tokenKey, newToken)
  }

  function logout() {
    token.value = null
    localStorage.removeItem(tokenKey)
    router.push('/login')
  }

  return { token, isLoggedIn, login, logout }
})
