import axios from 'axios'
import router from '@/router'

const baseURL =
  import.meta.env.MODE === 'development'
    ? '/api/' // dev: Proxy regelt Weiterleitung
    : import.meta.env.VITE_BASE + 'api/'; // staging: z. B. /frontend/eurobaustoff/admin/api/

    // 💡 Kundenspezifischer Token-Key
const customer = import.meta.env.VITE_CUSTOMER || 'default'
const tokenKey = `token_${customer}`

const api = axios.create({
  baseURL
})

// Token automatisch mitsenden
api.interceptors.request.use(config => {
  const token = localStorage.getItem(tokenKey)
  if (token) {
    config.headers.Authorization = `Bearer ${token}`
  }
  return config
})

// 🔐 401 automatisch abfangen und weiterleiten
api.interceptors.response.use(
  response => response,
  error => {
    if (error.response && error.response.status === 401) {
      localStorage.removeItem(tokenKey) // optional
      router.push('/login') // ⬅️ zur Login-Seite umleiten
    }
    return Promise.reject(error)
  }
)

export default api
