<!-- Einleitung -->
<section aria-labelledby="fenstertausch-ueberschrift" class="py-5">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center text-uppercase">
        <h1 id="fenstertausch-ueberschrift">FÖRDERGELDER zum Fenstertausch</h1>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <p>Neue Fenster mit Wärmeschutzverglasung sparen Heizkosten, vermeiden Zuglufterscheinungen und steigern den Wohnkomfort. Zusätzlich können sie barrierearm ausgeführt und vor Einbruch geschützt werden. Der fachgerechte Einbau ist gerade bei Fenstern das A und O. Hausbesitzer können dabei auf einen Energieeffizienz-Experten zurückgreifen.</p>
      </div>
    </div>
  </div>
</section>

<!-- Förderübersicht -->
<section class="bg-grey py-5" aria-labelledby="foerderuebersicht-fenster">
  <div class="container">
    <div class="row" role="list" aria-label="Förderarten Fenstertausch">

      <!-- Investitionszuschuss -->
      <article class="col-md-4" role="listitem">
        <h3><strong>Investitionszuschuss</strong></h3>
        <p><strong>15 % Zuschuss</strong></p>
        <ul>
          <li>je Wohneinheit und Jahr</li>
          <li>bis zu 30.000 &euro; förderfähige Ausgaben</li>
          <li>max. 4.500 &euro; Zuschuss</li>
        </ul>
        <p><strong>20 % Zuschuss</strong></p>
        <ul>
          <li>bei individuellem Sanierungsfahrplan (iSFP)</li>
          <li>bis zu 60.000 &euro; förderfähige Ausgaben</li>
          <li>max. 12.000 &euro; Zuschuss</li>
        </ul>
      </article>

      <!-- Ergänzungskredit -->
      <article class="col-md-4" role="listitem">
        <h3><strong>KfW-Ergänzungskredit</strong></h3>
        <ul>
          <li>zusätzlich zur Zuschussförderung</li>
          <li>bis zu 120.000 &euro; Kredit je Wohneinheit</li>
          <li>zinsgünstig ab 0,01 % (Stand: August 2024)</li>
          <li>inkl. tilgungsfreier Anlaufjahre</li>
        </ul>
      </article>

      <!-- Steuerliche Förderung -->
      <article class="col-md-4" role="listitem">
        <h3><strong>Steuerliche Förderung</strong></h3>
        <ul>
          <li><strong>20 % bis max. 40.000 &euro;</strong> über 3 Jahre</li>
          <li>für selbst genutztes Wohneigentum</li>
          <li>bei mind. 10 Jahre alten Wohngebäuden</li>
        </ul>
      </article>

    </div>
  </div>
</section>

<!-- Sanierungsbegleitung -->
<section class="py-5" aria-labelledby="energieberater-fenster">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h2 id="energieberater-fenster">Mit Energie-Effizienz-Experten zur Förderung</h2>
        <p>Für eine staatliche Förderung ist ein gelisteter Energieeffizienz-Experte Pflicht.</p>
      </div>
    </div>
    <div class="row mt-4">
      <div class="col-md-12">
        <p>Die Sanierungsbegleitung unterstützt Eigentümer, die ihre Immobilie modernisieren wollen. Energieberater des DEN e.V. begleiten Sie von der Planung bis zur Umsetzung und sorgen für Qualität und maximale Förderung.</p>
      </div>
    </div>
  </div>
</section>

<!-- Förderservice -->
<section class="bg-grey py-5" aria-labelledby="foerderservice-fenster">
  <div class="container">
    <div class="row" role="list" aria-label="Förderberatung zum Fenstertausch">

      <!-- Förderservice Fenstertausch -->
      <article class="col-md-4" role="listitem">
        <div class="text-center mb-3">
          <img src="pix/fenster.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Icon: Fenstertausch" style="max-height: 120px;" />
        </div>
        <h3 id="foerderservice-ueberschrift" class="h4 text-center"><strong>Förderservice Fenstertausch</strong></h3>
        <p>Die auf den Einbau von Wärmeschutzfenstern zugeschnittene Sanierungsbegleitung ist sinnvoll, wenn Sie:</p>
        <ul>
          <li>Eigentümer eines Wohnhauses mit Bauantrag vor mind. 5 Jahren sind</li>
          <li>eine Fenstererneuerung planen und noch nicht begonnen haben</li>
          <li>staatliche Fördergelder nutzen möchten</li>
          <li>eine Begleitung durch einen Energieberater wünschen</li>
        </ul>
      </article>

      <!-- BEG-Förderung & Energieberater -->
      <article class="col-md-4" role="listitem">
        <div class="text-center mb-3">
          <img src="pix/kfw-antrag.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Icon: KfW-Antrag" style="max-height: 120px;" />
        </div>
        <h3 class="h4 text-center"><strong>BEG-Förderung mit Energieberater</strong></h3>
        <p>Die Sanierungsbegleitung umfasst unter anderem:</p>
        <ul>
          <li>Beratung zu energetischen Mängeln und Sanierungsmaßnahmen</li>
          <li>Berechnung lüftungstechnischer Erfordernisse</li>
          <li>Prüfung der Handwerkerangebote nach GEG und BEG</li>
          <li>Bestätigung zum BEG-Förderantrag (BzA)</li>
          <li>Luftdichtheitskonzept für die Fachausführung</li>
          <li>stichprobenhafte Baukontrollen vor Ort</li>
          <li>Prüfung der Schlussrechnungen</li>
          <li>Zusammenstellung der förderfähigen Kosten</li>
          <li>Bestätigung nach Durchführung (BnD)</li>
        </ul>
        <div class="text-center mt-3">
          <a href="pix/checkliste_fenster.pdf" target="_blank" class="btn btn-warning" aria-label="Förderservice jetzt anfordern (PDF)">
            <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Förderservice anfordern</strong>
          </a>
        </div>
      </article>

      <!-- Komplettpaket anfragen -->
      <article class="col-md-4" role="listitem">
        <div class="text-center mb-3">
          <img src="pix/energieberater.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Icon: Energieberatung" style="max-height: 120px;" />
        </div>
        <h3 class="h4 text-center"><strong>Ihr Komplettpaket anfragen</strong></h3>
        <ul>
          <li><strong>Individuelle Energieberatung</strong></li>
          <li><strong>Sanierungsfahrplan</strong></li>
          <li><strong>BEG-Förderung</strong></li>
        </ul>
        <p><strong>So funktioniert es:</strong><br>
        Ihre Anfrage wird direkt an einen DEN-Energieberater in Ihrer Nähe übermittelt &ndash; unverbindlich und kostenlos. Der Berater meldet sich in wenigen Tagen mit einem Angebot und Terminvorschlag bei Ihnen.</p>
      </article>

    </div>
  </div>
</section>

<!-- Förderbeispiel -->
<section class="py-5" aria-labelledby="beispiel-foerderung">
 <div class="container">
    <div class="row">
      <div class="col-12 text-center">
        <h1 id="foerderbeispiel-ueberschrift">Förderbeispiel</h1>
        <h3>Der tatsächliche Förderbetrag hängt von vielen Faktoren ab und berechnet sich individuell.</h3>
        <p>Je nach Haus, zu dämmender Fläche, Fensteranteil oder auch Vor- und Rücksprüngen in der Fassade fallen sowohl der Modernisierungsumfang und deren Kosten, als auch die Förderung unterschiedlich aus.</p>
      </div>
    </div>

    <div class="row mt-4" role="list" aria-label="Beispielrechnungen">
      
      <!-- Fenstererneuerung -->
      <article class="col-md-4 border-end" role="listitem">
        <h3><strong>Fenstererneuerung</strong></h3>
        <p>
          In unserem Beispiel werden die Fenster eines freistehenden Einfamilienhauses mit 120&nbsp;m² Wohnfläche erneuert. Das Haus ist bisher unsaniert und wird mit einer Ölheizung beheizt. Die alten 2-fachverglasten Fenster werden durch neue Wärmeschutzfenster ersetzt.
        </p>
        <ul>
          <li>Kosten insgesamt: 20.000 &euro;</li>
          <li>Sanierungsfahrplan: 1.640 &euro;</li>
          <li>Förderservice BEG-Förderung: 399 &euro;</li>
        </ul>
      </article>

      <!-- Zuschuss ohne iSFP -->
      <article class="col-md-4" role="listitem">
        <h3><strong>3.000 &euro; Zuschuss</strong></h3>
        <p>Die Kosten von 20.399&nbsp;&euro; werden mit 3.000&nbsp;&euro; bezuschusst.</p>
        <ul>
          <li>Zuschuss: 3.000 &euro;</li>
          <li>Eigenanteil: 17.399 &euro;</li>
        </ul>
      </article>

      <!-- Zuschuss mit iSFP -->
      <article class="col-md-4 border-start" role="listitem">
        <h3><strong>4.650 &euro; Zuschuss mit Sanierungsfahrplan</strong></h3>
        <p>Die Kosten von 21.640&nbsp;&euro; werden mit 4.650&nbsp;&euro; bezuschusst.</p>
        <ul>
          <li>Sanierungszuschuss: 4.650 &euro;</li>
          <li>inkl. 650 &euro; Zuschuss für den Sanierungsfahrplan</li>
          <li>Eigenanteil: 16.990 &euro;</li>
        </ul>
        <p>Ein höherer Zuschuss ist für alle weiteren Maßnahmen an der Gebäudehülle durch den Sanierungsfahrplan möglich.</p>
      </article>

    </div>
  </div>
  </div>
</section>